//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import QtGraphicalEffects 1.0

import wesual.Controls 1.0

Flyout {
    id : menu

    property list<Action> items

    Rectangle {
        implicitWidth : 400
        implicitHeight: content.height

        Column {
            id : content

            width : parent.width
            height : childrenRect.height
            Repeater {
                model : items
                delegate : Rectangle {
                    width : parent.width
                    height : 30

                    Text {
                        anchors.fill : parent
                        text : modelData.text
                        horizontalAlignment : Qt.AlignHCenter
                        verticalAlignment : Qt.AlignVCenter
                        font {
                            family : UI.fontFamily(UI.PrimaryFont)
                            weight : UI.fontWeight(UI.PrimaryFont)
                        }
                    }

                    MouseArea {
                        anchors.fill : parent
                        enabled : modelData.enabled
                        acceptedButtons : Qt.LeftButton
                        onClicked : {
                            modelData.triggered();
                            menu.accept(index);
                        }
                    }
                }
            }
        }
    }
}
